# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import request_valid, user_photo, interface_response, SUCCESS_CODE, MESSAGE_CODE, \
    SYSTEM_EXCEPTION, DATA_EXCEPTION
import json


class BioTimeAppContact(object):

    """
    【Contact】通讯录
    """

    @request_valid
    @ladonize(str, int, int, str, str, str, rtype=str)
    def pull_contact(self, search_item, page_num, source, device_token, language, token):
        """
        获取通讯录
        @param search_item:     搜索条件(工号或者姓名), 为空字符串时返回全部数据
        @param page_num:        页码(每页１５条数据)
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:
            请求成功
                {"code": 1, "error": "", "describe": "", "message": "", "data":[{"code": 对象ID, "pin": "工号", "name":"姓名", "photo":"照片地址", "mobile": "手机号码", "email": "邮箱地址", "position":"职位"}, ]}
            请求失败
                {"code": -10001, "error": "", "describe": "异常详情", "message": "弹窗信息", "data":""}
        """
        from django.db.models import Q
        from mysite.personnel.models.model_emp import Employee
        try:
            emps = Employee.objects.all()
            search_item = search_item.strip()
            if search_item:
                emps = emps.filter(Q(EName__contains=search_item) | Q(PIN__contains=search_item))
            page_size = 15
            page_num = page_num or 1
            print "[*]Page size:{0}".format(page_size)
            print "[*]Page number:{0}".format(page_num)
            start = (page_num - 1) * page_size
            end = page_num * page_size
            emps = emps[start:end]
            data = []
            if emps:
                objs = emps.values('id', 'PIN', 'EName', 'Mobile', 'email', 'position__name')
                data = [{'code': obj['id'], 'pin': obj['PIN'], 'name': obj['EName'] or '', 'mobile': obj['Mobile'] or '', 'email': obj['email'] or '', 'position': obj['position__name'] or '', 'photo': user_photo(obj['PIN'])} for obj in objs]
            return interface_response(SUCCESS_CODE, json.dumps(data), '', '')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)

